/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;
import mage.players.Player;

enum OnePlayerHasTheMostCards implements Condition
{
    instance;


    public boolean apply(Game game, Ability source) {
        return OnePlayerHasTheMostCards.getPlayerWithMostCards(game, source) != null;
    }

    public static Player getPlayerWithMostCards(Game game, Ability source) {
        int max = Integer.MIN_VALUE;
        Player playerWithMost = null;
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            int cards = player.getHand().size();
            if (cards > max) {
                max = cards;
                playerWithMost = player;
                continue;
            }
            if (cards != max) continue;
            playerWithMost = null;
        }
        return playerWithMost;
    }

    public String toString() {
        return "a player has more cards in hand than each other player";
    }
}

