/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;

class ReturnSengirNosferatuEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("exiled card named Sengir Nosferatu");

    public ReturnSengirNosferatuEffect() {
        super(Outcome.Benefit);
    }

    private ReturnSengirNosferatuEffect(ReturnSengirNosferatuEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReturnSengirNosferatuEffect copy() {
        return new ReturnSengirNosferatuEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile(filter);
        target.withNotTarget(true);
        if (!target.canChoose(controller.getId(), source, game)) {
            return false;
        }
        controller.chooseTarget(Outcome.PutCreatureInPlay, (Target)target, source, game);
        Card card = game.getCard((UUID)target.getTargets().get(0));
        if (card != null) {
            return controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        return false;
    }

    static {
        filter.add((Predicate)new NamePredicate("Sengir Nosferatu"));
    }
}

