/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SabaccGameEffect
extends OneShotEffect {
    SabaccGameEffect() {
        super(Outcome.Detriment);
        this.staticText = "Choose target permanent an opponent controls. That opponent chooses a permanent you control. Flip a coin. If you win the flip, gain control of the permanent you chose. If you lose the flip, your opponent gains control of the permanent they chose";
    }

    private SabaccGameEffect(SabaccGameEffect effect) {
        super((OneShotEffect)effect);
    }

    public SabaccGameEffect copy() {
        return new SabaccGameEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player opponent;
            Permanent targetPermanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
            if (targetPermanent != null && (opponent = game.getPlayer(targetPermanent.getControllerId())) != null) {
                boolean flipWin;
                FilterPermanent filter = new FilterPermanent("permanent controlled by " + controller.getName());
                filter.add((Predicate)new ControllerIdPredicate(controller.getId()));
                TargetPermanent target = new TargetPermanent(1, 1, filter, true);
                Permanent chosenPermanent = null;
                if (target.chooseTarget(this.outcome, opponent.getId(), source, game)) {
                    chosenPermanent = game.getPermanent(target.getFirstTarget());
                }
                if (flipWin = controller.flipCoin(source, game, true)) {
                    GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, true, controller.getId());
                    effect.setTargetPointer((TargetPointer)new FixedTarget(targetPermanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                } else if (chosenPermanent != null) {
                    GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, true, opponent.getId());
                    effect.setTargetPointer((TargetPointer)new FixedTarget(chosenPermanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return true;
        }
        return false;
    }
}

