/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class SagesOfTheAnimaReplacementEffect
extends ReplacementEffectImpl {
    SagesOfTheAnimaReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would draw a card, instead reveal the top three cards of your library. Put all creature cards revealed this way into your hand and the rest on the bottom of your library in any order";
    }

    private SagesOfTheAnimaReplacementEffect(SagesOfTheAnimaReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public SagesOfTheAnimaReplacementEffect copy() {
        return new SagesOfTheAnimaReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        if (player != null) {
            CardsImpl revealedCards = new CardsImpl(player.getLibrary().getTopCards(game, 3));
            player.revealCards(source, (Cards)revealedCards, game);
            CardsImpl creatures = new CardsImpl(revealedCards.getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
            player.moveCards((Cards)creatures, Zone.HAND, source, game);
            revealedCards.removeAll((Collection)creatures);
            player.putCardsOnBottomOfLibrary((Cards)revealedCards, game, source, true);
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId());
    }
}

