/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SaheeliRaiCreateTokenEffect
extends OneShotEffect {
    SaheeliRaiCreateTokenEffect() {
        super(Outcome.Copy);
        this.staticText = "Create a token that's a copy of target artifact or creature you control, except it's an artifact in addition to its other types. That token gains haste. Exile it at the beginning of the next end step";
    }

    private SaheeliRaiCreateTokenEffect(SaheeliRaiCreateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public SaheeliRaiCreateTokenEffect copy() {
        return new SaheeliRaiCreateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CreateTokenCopyTargetEffect effect;
        Permanent copiedPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (copiedPermanent != null && (effect = new CreateTokenCopyTargetEffect(null, CardType.ARTIFACT, true)).apply(game, source)) {
            for (Permanent copyPermanent : effect.getAddedPermanents()) {
                ExileTargetEffect exileEffect = new ExileTargetEffect();
                exileEffect.setTargetPointer((TargetPointer)new FixedTarget(copyPermanent, game));
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect);
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            }
            return true;
        }
        return false;
    }
}

