/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SaheeliTheGiftedTokenEffect
extends OneShotEffect {
    SaheeliTheGiftedTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each artifact you control, create a token that's a copy of it. Those tokens gain haste. Exile those tokens at the beginning of the next end step.";
    }

    private SaheeliTheGiftedTokenEffect(SaheeliTheGiftedTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public SaheeliTheGiftedTokenEffect copy() {
        return new SaheeliTheGiftedTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT_AN, source.getControllerId(), game)) {
            if (permanent == null) continue;
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            effect.setHasHaste(true);
            effect.apply(game, source);
            effect.exileTokensCreatedAtNextEndStep(game, source);
        }
        return true;
    }
}

