/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class SaheelisDirectiveEffect
extends OneShotEffect {
    SaheelisDirectiveEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Reveal the top X cards of your library. You may put any number of artifact cards with mana value X or less from among them onto the battlefield. Then put all cards revealed this way that weren't put onto the battlefield into your graveyard.";
    }

    private SaheelisDirectiveEffect(SaheelisDirectiveEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, xValue));
        if (!cards.isEmpty()) {
            controller.revealCards(source, (Cards)cards, game);
            FilterArtifactCard filter = new FilterArtifactCard("artifact cards with mana value " + xValue + " or less to put onto the battlefield");
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue + 1));
            TargetCard target1 = new TargetCard(0, Integer.MAX_VALUE, Zone.LIBRARY, (FilterCard)filter);
            target1.withNotTarget(true);
            controller.choose(Outcome.PutCardInPlay, (Cards)cards, target1, source, game);
            CardsImpl toBattlefield = new CardsImpl((Collection)target1.getTargets());
            cards.removeAll((Collection)toBattlefield);
            controller.moveCards(toBattlefield.getCards(game), Zone.BATTLEFIELD, source, game, false, false, false, null);
            controller.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        }
        return true;
    }

    public SaheelisDirectiveEffect copy() {
        return new SaheelisDirectiveEffect(this);
    }
}

