/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SakashimasWillStealEffect
extends OneShotEffect {
    SakashimasWillStealEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent chooses a creature they control. You gain control of it";
    }

    private SakashimasWillStealEffect(SakashimasWillStealEffect effect) {
        super((OneShotEffect)effect);
    }

    public SakashimasWillStealEffect copy() {
        return new SakashimasWillStealEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        if (!target.canChoose(player.getId(), source, game)) {
            return false;
        }
        player.choose(this.outcome, (Target)target, source, game);
        if (game.getPermanent(target.getFirstTarget()) == null) {
            return false;
        }
        game.addEffect(new GainControlTargetEffect(Duration.Custom, true, source.getControllerId()).setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game)), source);
        return true;
    }
}

