/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class SamLoyalAttendantEffect
extends CostModificationEffectImpl {
    SamLoyalAttendantEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "activated abilities of Foods you control cost {1} less to activate";
    }

    private SamLoyalAttendantEffect(SamLoyalAttendantEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public SamLoyalAttendantEffect copy() {
        return new SamLoyalAttendantEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)1);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!abilityToModify.isActivatedAbility()) {
            return false;
        }
        Permanent permanent = abilityToModify.getSourcePermanentIfItStillExists(game);
        return permanent != null && permanent.isControlledBy(source.getControllerId()) && permanent.hasSubtype(SubType.FOOD, game);
    }
}

