/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class SanctumPrelateReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    SanctumPrelateReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Noncreature spells with mana value equal to the chosen number can't be cast";
    }

    private SanctumPrelateReplacementEffect(SanctumPrelateReplacementEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public SanctumPrelateReplacementEffect copy() {
        return new SanctumPrelateReplacementEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast a noncreature card with that mana value (" + mageObject.getIdName() + " in play).";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL_LATE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Integer choiceValue = (Integer)game.getState().getValue(source.getSourceId().toString());
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell != null && !spell.isCreature(game) && choiceValue != null) {
            return spell.getManaValue() == choiceValue.intValue();
        }
        return false;
    }
}

