/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SandsOfTimeEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent();

    public SandsOfTimeEffect() {
        super(Outcome.Neutral);
        this.staticText = "that player simultaneously untaps each tapped artifact, creature, and land they control and taps each untapped artifact, creature, and land they control";
    }

    private SandsOfTimeEffect(SandsOfTimeEffect copy) {
        super((OneShotEffect)copy);
    }

    public SandsOfTimeEffect copy() {
        return new SandsOfTimeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, this.getTargetPointer().getFirst(game, source), game)) {
                if (permanent.isTapped()) {
                    permanent.untap(game);
                    continue;
                }
                permanent.tap(source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

