/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SanguinePraetorEffect
extends OneShotEffect {
    SanguinePraetorEffect() {
        super(Outcome.Damage);
        this.staticText = "Destroy each creature with the same mana value as the sacrificed creature";
    }

    private SanguinePraetorEffect(SanguinePraetorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int cmc = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost) || ((SacrificeTargetCost)cost).getPermanents().isEmpty()) continue;
            cmc = ((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getManaValue();
            break;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game)) {
            if (permanent.getManaValue() != cmc) continue;
            permanent.destroy(source, game, false);
        }
        return true;
    }

    public SanguinePraetorEffect copy() {
        return new SanguinePraetorEffect(this);
    }
}

