/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SaprazzanBailiffEffect
extends OneShotEffect {
    SaprazzanBailiffEffect() {
        super(Outcome.Detriment);
        this.staticText = "exile all artifact and enchantment cards from all graveyards";
    }

    private SaprazzanBailiffEffect(SaprazzanBailiffEffect effect) {
        super((OneShotEffect)effect);
    }

    public SaprazzanBailiffEffect copy() {
        return new SaprazzanBailiffEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            for (UUID cid : player.getGraveyard().copy()) {
                Card card = game.getCard(cid);
                if (card == null || !card.isArtifact(game) && !card.isEnchantment(game)) continue;
                controller.moveCardToExileWithInfo(card, null, "", source, game, Zone.GRAVEYARD, true);
            }
        }
        return true;
    }
}

