/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBeBlockedByAllSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class SaprazzanBreakerEffect
extends OneShotEffect {
    SaprazzanBreakerEffect() {
        super(Outcome.Benefit);
        this.staticText = "Mill a card. If a land card was milled this way, {this} can't be blocked this turn";
    }

    private SaprazzanBreakerEffect(SaprazzanBreakerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SaprazzanBreakerEffect copy() {
        return new SaprazzanBreakerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.millCards(1, source, game).getCards(game).stream().filter(Objects::nonNull).anyMatch(card -> card.isLand(game))) {
            game.addEffect((ContinuousEffect)new CantBeBlockedByAllSourceEffect(StaticFilters.FILTER_PERMANENT_CREATURES, Duration.EndOfTurn), source);
        }
        return true;
    }
}

