/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class SarevoksTomeEffect
extends OneShotEffect {
    SarevoksTomeEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile cards from the top of your library until you exile a nonland card. You may cast that card without paying its mana cost";
    }

    private SarevoksTomeEffect(SarevoksTomeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SarevoksTomeEffect copy() {
        return new SarevoksTomeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (Card card : player.getLibrary().getCards(game)) {
            player.moveCards(card, Zone.EXILED, source, game);
            if (card.isLand(game)) continue;
            CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Card)card);
            break;
        }
        return true;
    }
}

