/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SaskiaTheUnyieldingEffect
extends OneShotEffect {
    SaskiaTheUnyieldingEffect() {
        super(Outcome.Detriment);
        this.staticText = "it deals that much damage to the chosen player";
    }

    private SaskiaTheUnyieldingEffect(SaskiaTheUnyieldingEffect effect) {
        super((OneShotEffect)effect);
    }

    public SaskiaTheUnyieldingEffect copy() {
        return new SaskiaTheUnyieldingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            UUID playerId = (UUID)game.getState().getValue(source.getSourceId() + "_player");
            Player player = game.getPlayer(playerId);
            if (player != null && player.canRespond()) {
                Integer damage = (Integer)this.getValue("damage");
                UUID sourceId = (UUID)this.getValue("sourceId");
                if (sourceId != null && damage > 0) {
                    player.damage(damage.intValue(), sourceId, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

