/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.NinjutsuAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class SatoruUmezawaEffect
extends ContinuousEffectImpl {
    SatoruUmezawaEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "each creature card in your hand has ninjutsu {2}{U}{B}";
    }

    private SatoruUmezawaEffect(SatoruUmezawaEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SatoruUmezawaEffect copy() {
        return new SatoruUmezawaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (Card card : player.getHand().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game)) {
            game.getState().addOtherAbility(card, (Ability)new NinjutsuAbility("{2}{U}{B}"));
        }
        return true;
    }
}

