/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.InvertCondition;
import mage.abilities.condition.common.SourceIsRingBearerCondition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.keyword.MenaceAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class SauronTheNecromancerEffect
extends OneShotEffect {
    private static final Condition condition = new InvertCondition((Condition)SourceIsRingBearerCondition.instance);

    SauronTheNecromancerEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target creature card from your graveyard. Create a tapped and attacking token that's a copy of that card, except it's a 3/3 black Wraith with menace. At the beginning of the next end step, exile that token unless {this} is your Ring-bearer";
    }

    private SauronTheNecromancerEffect(SauronTheNecromancerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SauronTheNecromancerEffect copy() {
        return new SauronTheNecromancerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, null, false, 1, true, true);
        effect.setPermanentModifier(token -> {
            token.setColor(ObjectColor.BLACK);
            token.addSubType(new SubType[]{SubType.WRAITH});
            token.setPower(3);
            token.setToughness(3);
            token.addAbility((Ability)new MenaceAbility(false));
        });
        effect.apply(game, source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new ConditionalOneShotEffect((OneShotEffect)new ExileTargetEffect(), condition, "exile that token unless {this} is your Ring-bearer").setTargetPointer((TargetPointer)new FixedTargets((Collection)effect.getAddedPermanents(), game))), source);
        return true;
    }
}

