/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;

class SavageAllianceGainTrampleEffect
extends OneShotEffect {
    SavageAllianceGainTrampleEffect() {
        super(Outcome.AddAbility);
        this.staticText = "Creatures target player controls gain trample until end of turn";
    }

    private SavageAllianceGainTrampleEffect(SavageAllianceGainTrampleEffect effect) {
        super((OneShotEffect)effect);
    }

    public SavageAllianceGainTrampleEffect copy() {
        return new SavageAllianceGainTrampleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new ControllerIdPredicate(player.getId()));
            GainAbilityAllEffect effect = new GainAbilityAllEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filter);
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

