/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.SearchEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class SavageOrderEffect
extends SearchEffect {
    private static final FilterCreatureCard filterCard = new FilterCreatureCard("Dinosaur creature card");

    SavageOrderEffect() {
        super(new TargetCardInLibrary(0, 1, (FilterCard)filterCard), Outcome.PutCardInPlay);
        this.staticText = "Search your library for a Dinosaur creature card, put it onto the battlefield, then shuffle. It gains indestructible until your next turn";
    }

    private SavageOrderEffect(SavageOrderEffect effect) {
        super((SearchEffect)effect);
    }

    public SavageOrderEffect copy() {
        return new SavageOrderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (controller.searchLibrary(this.target, source, game)) {
                Card card;
                if (!this.target.getTargets().isEmpty() && (card = controller.getLibrary().getCard(this.target.getFirstTarget(), game)) != null) {
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                    Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
                    if (permanent != null) {
                        GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance(), Duration.UntilYourNextTurn);
                        effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), permanent.getZoneChangeCounter(game)));
                        game.addEffect((ContinuousEffect)effect, source);
                    }
                }
                controller.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filterCard.add((Predicate)SubType.DINOSAUR.getPredicate());
    }
}

