/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.s.SavageSummoningWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.command.Commander;

class SavageSummoningAsThoughEffect
extends AsThoughEffectImpl {
    private SavageSummoningWatcher watcher;
    private int zoneChangeCounter;

    public SavageSummoningAsThoughEffect() {
        super(AsThoughEffectType.CAST_AS_INSTANT, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "The next creature spell you cast this turn can be cast as though it had flash";
    }

    private SavageSummoningAsThoughEffect(SavageSummoningAsThoughEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.watcher = effect.watcher;
        this.zoneChangeCounter = effect.zoneChangeCounter;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.watcher = (SavageSummoningWatcher)game.getState().getWatcher(SavageSummoningWatcher.class, source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (this.watcher == null || card == null) {
            throw new IllegalArgumentException("Consume Savage watcher could not be found");
        }
        this.watcher.setSavageSummoningSpellActive(card, game);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public SavageSummoningAsThoughEffect copy() {
        return new SavageSummoningAsThoughEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card card;
        Commander commander;
        MageObject mageObject;
        return this.watcher.isSavageSummoningSpellActive() && ((mageObject = game.getBaseObject(objectId)) instanceof Commander ? (commander = (Commander)mageObject).isCreature(game) && commander.isControlledBy(source.getControllerId()) : mageObject instanceof Card && (card = (Card)mageObject).isCreature(game) && card.isOwnedBy(source.getControllerId()));
    }
}

