/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileTargetForSourceEffect;
import mage.abilities.keyword.TrainingAbility;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyardBattlefieldOrStack;

class SaviorOfOllenbockTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("other target creature");

    SaviorOfOllenbockTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ExileTargetForSourceEffect());
        this.addTarget((Target)new TargetCardInGraveyardBattlefieldOrStack(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE, (FilterPermanent)filter));
    }

    private SaviorOfOllenbockTriggeredAbility(SaviorOfOllenbockTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SaviorOfOllenbockTriggeredAbility copy() {
        return new SaviorOfOllenbockTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getData().equals(CounterType.P1P1.getName())) {
            return false;
        }
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (!(stackObject instanceof StackAbility)) {
            return false;
        }
        Ability ability = stackObject.getStackAbility();
        if (!(ability instanceof TrainingAbility)) {
            return false;
        }
        return event.getTargetId().equals(this.getSourceId());
    }

    public String getRule() {
        return "Whenever {this} trains, exile up to one other target creature from the battlefield or creature card from a graveyard.";
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

