/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ScholarOfCombustionEffect
extends OneShotEffect {
    ScholarOfCombustionEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target instant or sorcery card from your graveyard. You may cast that card until the end of your next turn";
    }

    private ScholarOfCombustionEffect(ScholarOfCombustionEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScholarOfCombustionEffect copy() {
        return new ScholarOfCombustionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.UntilEndOfYourNextTurn, (boolean)false);
        return true;
    }
}

