/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.OpponentControlsMoreCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class ScholarOfNewHorizonsEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterLandCard("Plains card");
    private static final Condition condition;

    ScholarOfNewHorizonsEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for a Plains card and reveal it. If an opponent controls more lands than you, you may put that card onto the battlefield tapped. If you don't put the card onto the battlefield, put it into your hand. Then shuffle";
    }

    private ScholarOfNewHorizonsEffect(ScholarOfNewHorizonsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScholarOfNewHorizonsEffect copy() {
        return new ScholarOfNewHorizonsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, 1, filter);
        player.searchLibrary(target, source, game);
        Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (!(card != null && condition.apply(game, source) && player.chooseUse(this.outcome, "Put the card onto the battlfield tapped?", source, game) && player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null))) {
            player.moveCards(card, Zone.HAND, source, game);
        }
        player.shuffleLibrary(source, game);
        return true;
    }

    static {
        filter.add((Predicate)SubType.PLAINS.getPredicate());
        condition = new OpponentControlsMoreCondition((FilterPermanent)StaticFilters.FILTER_LAND);
    }
}

