/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.replacement.ThatSpellGraveyardExileReplacementEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ScholarOfTheLostTroveEffect
extends OneShotEffect {
    ScholarOfTheLostTroveEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "you may cast target instant, sorcery, or artifact card from your graveyard without paying its mana cost. If an instant or sorcery spell cast this way would be put into your graveyard, exile it instead";
    }

    private ScholarOfTheLostTroveEffect(ScholarOfTheLostTroveEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScholarOfTheLostTroveEffect copy() {
        return new ScholarOfTheLostTroveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null) {
            return true;
        }
        if (!controller.chooseUse(Outcome.PlayForFree, "Cast " + card.getLogName() + '?', source, game)) {
            return true;
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
        boolean cardWasCast = controller.cast(controller.chooseAbilityForCast(card, game, true), game, true, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        if (!cardWasCast || !card.isInstantOrSorcery(game)) {
            return true;
        }
        ThatSpellGraveyardExileReplacementEffect effect = new ThatSpellGraveyardExileReplacementEffect(true);
        effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
        effect.setText("If an instant or sorcery spell cast this way would be put into your graveyard this turn, exile it instead");
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

