/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ScorchSpitterTriggeredAbility
extends TriggeredAbilityImpl {
    ScorchSpitterTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private ScorchSpitterTriggeredAbility(ScorchSpitterTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ScorchSpitterTriggeredAbility copy() {
        return new ScorchSpitterTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (this.getSourceId().equals(event.getSourceId())) {
            this.getEffects().clear();
            DamageTargetEffect effect = new DamageTargetEffect(1);
            effect.setTargetPointer((TargetPointer)new FixedTarget(game.getCombat().getDefenderId(event.getSourceId()), game));
            this.addEffect((Effect)effect);
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} attacks, it deals 1 damage to the player or planeswalker it's attacking.";
    }
}

