/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ScourgeOfSkolaValeEffect
extends OneShotEffect {
    ScourgeOfSkolaValeEffect() {
        super(Outcome.GainLife);
        this.staticText = "Put a number of +1/+1 counters on {this} equal to the sacrificed creature's toughness";
    }

    private ScourgeOfSkolaValeEffect(ScourgeOfSkolaValeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScourgeOfSkolaValeEffect copy() {
        return new ScourgeOfSkolaValeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            int amount = ((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getToughness().getValue();
            Player player = game.getPlayer(source.getControllerId());
            if (amount <= 0 || player == null) continue;
            return new AddCountersSourceEffect(CounterType.P1P1.createInstance(amount), true).apply(game, source);
        }
        return false;
    }
}

