/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.PlayerList;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.RandomUtil;

class ScrambleverseEffect
extends OneShotEffect {
    ScrambleverseEffect() {
        super(Outcome.Damage);
        this.staticText = "For each nonland permanent, choose a player at random. Then each player gains control of each permanent for which they were chosen. Untap those permanents";
    }

    private ScrambleverseEffect(ScrambleverseEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        PlayerList players = game.getState().getPlayersInRange(source.getControllerId(), game);
        int count = players.size();
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterNonlandPermanent(), source.getControllerId(), source, game)) {
            GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, true, (UUID)players.get(RandomUtil.nextInt((int)count)));
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
            permanent.untap(game);
        }
        return true;
    }

    public ScrambleverseEffect copy() {
        return new ScrambleverseEffect(this);
    }
}

