/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

class ScrollRackEffect
extends OneShotEffect {
    ScrollRackEffect() {
        super(Outcome.Neutral);
        this.staticText = "Exile any number of cards from your hand face down. Put that many cards from the top of your library into your hand. Then look at the exiled cards and put them on top of your library in any order";
    }

    private ScrollRackEffect(ScrollRackEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            FilterCard filter = new FilterCard("card in your hand to exile");
            TargetCardInHand target = new TargetCardInHand(0, controller.getHand().size(), filter);
            int amountExiled = 0;
            if (target.canChoose(source.getControllerId(), source, game) && target.choose(Outcome.Neutral, source.getControllerId(), source.getSourceId(), source, game) && !target.getTargets().isEmpty()) {
                for (UUID targetId : target.getTargets()) {
                    Card card = game.getCard(targetId);
                    if (card == null) continue;
                    card.setFaceDown(true, game);
                    ++amountExiled;
                }
                controller.moveCardsToExile(new CardsImpl((Collection)target.getTargets()).getCards(game), source, game, false, source.getSourceId(), sourceObject.getIdName());
                ExileZone exileZone = game.getExile().getExileZone(source.getSourceId());
                if (exileZone != null) {
                    for (Card card : exileZone.getCards(game)) {
                        card.setFaceDown(true, game);
                    }
                }
            }
            if (amountExiled > 0) {
                controller.moveCards(controller.getLibrary().getTopCards(game, amountExiled), Zone.HAND, source, game);
            }
            controller.putCardsOnTopOfLibrary((Cards)game.getExile().getExileZone(source.getSourceId()), game, source, true);
            return true;
        }
        return false;
    }

    public ScrollRackEffect copy() {
        return new ScrollRackEffect(this);
    }
}

