/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.permanent.token.LanderToken;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

public final class ScroungeForEternity
extends CardImpl {
    private static final FilterCard filter = new FilterCard("creature or Spacecraft card with mana value 5 or less from your graveyard");

    public ScroungeForEternity(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{2}{B}");
        this.getSpellAbility().addCost((Cost)new SacrificeTargetCost(StaticFilters.FILTER_PERMANENT_ARTIFACT_OR_CREATURE));
        this.getSpellAbility().addEffect((Effect)new ReturnFromGraveyardToBattlefieldTargetEffect());
        this.getSpellAbility().addTarget((Target)new TargetCardInYourGraveyard(filter));
        this.getSpellAbility().addEffect((Effect)new CreateTokenEffect((Token)new LanderToken()).concatBy("Then"));
    }

    private ScroungeForEternity(ScroungeForEternity card) {
        super((CardImpl)card);
    }

    public ScroungeForEternity copy() {
        return new ScroungeForEternity(this);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)SubType.SPACECRAFT.getPredicate()));
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 6));
    }
}

