/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ScryingSheetsEffect
extends OneShotEffect {
    ScryingSheetsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at the top card of your library. If that card is snow, you may reveal it and put it into your hand";
    }

    private ScryingSheetsEffect(ScryingSheetsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScryingSheetsEffect copy() {
        return new ScryingSheetsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                CardsImpl cards = new CardsImpl();
                cards.add(card);
                controller.lookAtCards(sourceObject.getIdName(), (Cards)cards, game);
                if (card.isSnow(game) && controller.chooseUse(this.outcome, "Reveal " + card.getLogName() + " and put it into your hand?", source, game)) {
                    controller.moveCards(card, Zone.HAND, source, game);
                    controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
                }
            }
            return true;
        }
        return false;
    }
}

