/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ScytheOfTheWretchedReanimateEffect
extends OneShotEffect {
    ScytheOfTheWretchedReanimateEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "return that card to the battlefield under your control. Attach {this} to that creature";
    }

    private ScytheOfTheWretchedReanimateEffect(ScytheOfTheWretchedReanimateEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (card == null || controller == null) {
            return false;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null) {
            AttachEffect effect = new AttachEffect(Outcome.AddAbility);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), game));
            effect.apply(game, source);
        }
        return true;
    }

    public ScytheOfTheWretchedReanimateEffect copy() {
        return new ScytheOfTheWretchedReanimateEffect(this);
    }
}

