/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class SealOfTheGuildpactCostReductionEffect
extends CostModificationEffectImpl {
    SealOfTheGuildpactCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Each spell you cast costs {1} less to cast for each of the chosen colors it is";
    }

    private SealOfTheGuildpactCostReductionEffect(SealOfTheGuildpactCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        MageObject sourceObject = game.getObject(abilityToModify.getSourceId());
        if (sourceObject != null) {
            ObjectColor color1 = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color1");
            ObjectColor color2 = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color2");
            int amount = 0;
            if (color1 != null && sourceObject.getColor(game).contains(color1)) {
                ++amount;
            }
            if (color2 != null && sourceObject.getColor(game).contains(color2)) {
                ++amount;
            }
            if (amount > 0) {
                SpellAbility spellAbility = (SpellAbility)abilityToModify;
                CardUtil.adjustCost((SpellAbility)spellAbility, (int)amount);
            }
            return true;
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify.isControlledBy(source.getControllerId()) && abilityToModify instanceof SpellAbility;
    }

    public SealOfTheGuildpactCostReductionEffect copy() {
        return new SealOfTheGuildpactCostReductionEffect(this);
    }
}

