/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.AbilityWord;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.watchers.common.LandfallWatcher;

class SearingBlazeEffect
extends OneShotEffect {
    SearingBlazeEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 1 damage to target player or planeswalker and 1 damage to target creature that player or that planeswalker's controller controls.<br>" + AbilityWord.LANDFALL.formatWord() + "If you had a land enter the battlefield under your control this turn, {this} deals 3 damage to that player or planeswalker and 3 damage to that creature instead.";
    }

    private SearingBlazeEffect(SearingBlazeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SearingBlazeEffect copy() {
        return new SearingBlazeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        LandfallWatcher watcher = (LandfallWatcher)game.getState().getWatcher(LandfallWatcher.class);
        Permanent creature = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        int damage = 1;
        if (watcher != null && watcher.landPlayed(source.getControllerId())) {
            damage = 3;
        }
        game.damagePlayerOrPermanent(((Target)source.getTargets().get(0)).getFirstTarget(), damage, source.getSourceId(), source, game, false, true);
        if (creature != null) {
            creature.damage(damage, source.getSourceId(), source, game, false, true);
        }
        return true;
    }
}

