/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class SearingRaysEffect
extends OneShotEffect {
    SearingRaysEffect() {
        super(Outcome.Damage);
        this.staticText = "Choose a color. {this} deals damage to each player equal to the number of creatures of that color that player controls";
    }

    private SearingRaysEffect(SearingRaysEffect effect) {
        super((OneShotEffect)effect);
    }

    public SearingRaysEffect copy() {
        return new SearingRaysEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        ChoiceColor choice = new ChoiceColor();
        if (controller != null && controller.choose(this.outcome, (Choice)choice, game) && choice.getColor() != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent(choice.getColor().getDescription() + " creatures");
            filter.add((Predicate)new ColorPredicate(choice.getColor()));
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                int amount = game.getBattlefield().countAll((FilterPermanent)filter, playerId, game);
                if (amount <= 0 || (player = game.getPlayer(playerId)) == null) continue;
                player.damage(amount, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

