/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterArtifactPermanent;
import mage.game.Game;
import mage.players.Player;

class SeasonOfGatheringRemovalEffect
extends OneShotEffect {
    private static final Set<String> choice = new HashSet<String>();

    SeasonOfGatheringRemovalEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Choose artifact or enchantment. Destroy all permanents of the chosen type.";
    }

    private SeasonOfGatheringRemovalEffect(SeasonOfGatheringRemovalEffect effect) {
        super((OneShotEffect)effect);
    }

    public SeasonOfGatheringRemovalEffect copy() {
        return new SeasonOfGatheringRemovalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterArtifactPermanent filter;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ChoiceImpl choiceImpl = new ChoiceImpl(true);
        choiceImpl.setMessage("Choose card type to destroy");
        choiceImpl.setChoices(choice);
        if (!controller.choose(Outcome.Neutral, (Choice)choiceImpl, game)) {
            return false;
        }
        switch (choiceImpl.getChoice()) {
            case "Artifact": {
                filter = StaticFilters.FILTER_PERMANENT_ARTIFACT;
                break;
            }
            case "Enchantment": {
                filter = StaticFilters.FILTER_PERMANENT_ENCHANTMENT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Choice is required");
            }
        }
        game.informPlayers(controller.getLogName() + " has chosen " + choiceImpl.getChoiceKey());
        return new DestroyAllEffect((FilterPermanent)filter).apply(game, source);
    }

    static {
        choice.add(CardType.ARTIFACT.toString());
        choice.add(CardType.ENCHANTMENT.toString());
    }
}

