/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.RedElementalToken;
import mage.players.Player;

class SeasonedPyromancerEffect
extends OneShotEffect {
    SeasonedPyromancerEffect() {
        super(Outcome.Benefit);
        this.staticText = "discard two cards, then draw two cards. For each nonland card discarded this way, create a 1/1 red Elemental creature token.";
    }

    private SeasonedPyromancerEffect(SeasonedPyromancerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SeasonedPyromancerEffect copy() {
        return new SeasonedPyromancerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int nonlands = player.discard(2, false, false, source, game).count((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game);
        player.drawCards(2, source, game);
        if (nonlands == 0) {
            return true;
        }
        new RedElementalToken().putOntoBattlefield(nonlands, game, source, source.getControllerId());
        return true;
    }
}

