/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SecondSightEffect
extends OneShotEffect {
    SecondSightEffect() {
        super(Outcome.DrawCard);
        this.staticText = "look at the top five cards of target opponent's library, then put them back in any order";
    }

    private SecondSightEffect(SecondSightEffect effect) {
        super((OneShotEffect)effect);
    }

    public SecondSightEffect copy() {
        return new SecondSightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null || controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 5));
        controller.lookAtCards(source, null, (Cards)cards, game);
        controller.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
        return true;
    }
}

