/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.watchers.common.SpellsCastWatcher;

class SeeTheTruthEffect
extends OneShotEffect {
    SeeTheTruthEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at the top three cards of your library. Put one of those cards into your hand and the rest on the bottom of your library in any order. If this spell was cast from anywhere other than your hand, put each of those cards into your hand instead.";
    }

    private SeeTheTruthEffect(SeeTheTruthEffect effect) {
        super((OneShotEffect)effect);
    }

    public SeeTheTruthEffect copy() {
        return new SeeTheTruthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Spell sourceSpell = game.getStack().getSpell(source.getId());
        if (player == null || sourceSpell == null) {
            return false;
        }
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        boolean wasCast = watcher != null && watcher.getAllSpellsCastThisTurn().anyMatch(s -> s.getId().equals(source.getId()));
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 3));
        if (!cards.isEmpty()) {
            if (!wasCast || Zone.HAND.equals((Object)sourceSpell.getFromZone())) {
                TargetCardInLibrary target = new TargetCardInLibrary(new FilterCard("card to put into your hand"));
                player.chooseTarget(this.outcome, (Cards)cards, (TargetCard)target, source, game);
                cards.removeIf(target.getFirstTarget()::equals);
                player.moveCards(game.getCard(target.getFirstTarget()), Zone.HAND, source, game);
                player.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
            } else {
                player.moveCards((Cards)cards, Zone.HAND, source, game);
            }
        }
        return true;
    }
}

