/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SeedsOfInnocenceEffect
extends OneShotEffect {
    SeedsOfInnocenceEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all artifacts. They can't be regenerated. The controller of each of those artifacts gains life equal to its mana value";
    }

    private SeedsOfInnocenceEffect(SeedsOfInnocenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public SeedsOfInnocenceEffect copy() {
        return new SeedsOfInnocenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (Permanent artifact : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterArtifactPermanent(), controller.getId(), game)) {
                Player artifactController = game.getPlayer(artifact.getControllerId());
                int cmc = artifact.getManaValue();
                if (!artifact.destroy(source, game, true) || artifactController == null) continue;
                artifactController.gainLife(cmc, game, source);
            }
            return true;
        }
        return false;
    }
}

