/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SeekerOfSlaaneshForceAttackEffect
extends RequirementEffect {
    SeekerOfSlaaneshForceAttackEffect(Duration duration) {
        super(duration, true);
        this.staticText = "Each opponent must attack with at least one creature each combat if able.";
    }

    private SeekerOfSlaaneshForceAttackEffect(SeekerOfSlaaneshForceAttackEffect effect) {
        super((RequirementEffect)effect);
    }

    public SeekerOfSlaaneshForceAttackEffect copy() {
        return new SeekerOfSlaaneshForceAttackEffect(this);
    }

    public boolean mustAttack(Game game) {
        return true;
    }

    public boolean mustBlock(Game game) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        return controller != null && controller.hasOpponent(game.getActivePlayerId(), game);
    }
}

