/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SeizuresEffect
extends OneShotEffect {
    SeizuresEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 3 damage to that creature's controller unless that player pays {3}";
    }

    private SeizuresEffect(SeizuresEffect effect) {
        super((OneShotEffect)effect);
    }

    public SeizuresEffect copy() {
        return new SeizuresEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantment = source.getSourcePermanentOrLKI(game);
        if (enchantment == null) {
            return false;
        }
        Permanent enchanted = game.getPermanentOrLKIBattlefield(enchantment.getAttachedTo());
        if (enchanted == null) {
            return false;
        }
        Player player = game.getPlayer(enchanted.getControllerId());
        if (player != null) {
            ManaCostsImpl cost = new ManaCostsImpl("{3}");
            if (cost.canPay(source, source, player.getId(), game) && player.chooseUse(Outcome.Benefit, "Pay " + cost.getText() + " to avoid damage?", source, game)) {
                cost.clearPaid();
                if (cost.pay(source, game, source, player.getId(), false, null)) {
                    return true;
                }
            }
            player.damage(3, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }
}

