/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class SelectiveMemoryEffect
extends OneShotEffect {
    SelectiveMemoryEffect() {
        super(Outcome.Exile);
        this.staticText = "Search your library for any number of nonland cards, exile them, then shuffle";
    }

    private SelectiveMemoryEffect(SelectiveMemoryEffect effect) {
        super((OneShotEffect)effect);
    }

    public SelectiveMemoryEffect copy() {
        return new SelectiveMemoryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARDS_NON_LAND);
        player.searchLibrary(target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        cards.retainZone(Zone.LIBRARY, game);
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }
}

