/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SelflessExorcistEffect
extends OneShotEffect {
    SelflessExorcistEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target creature card from a graveyard. That card deals damage equal to its power to {this}";
    }

    private SelflessExorcistEffect(SelflessExorcistEffect effect) {
        super((OneShotEffect)effect);
    }

    public SelflessExorcistEffect copy() {
        return new SelflessExorcistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        game.processAction();
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return true;
        }
        permanent.damage(card.getPower().getValue(), card.getId(), source, game);
        return true;
    }
}

