/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;

class SelflessSquireTriggeredAbility
extends TriggeredAbilityImpl {
    public SelflessSquireTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private SelflessSquireTriggeredAbility(SelflessSquireTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SelflessSquireTriggeredAbility copy() {
        return new SelflessSquireTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return GameEvent.EventType.PREVENTED_DAMAGE == event.getType();
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (this.isControlledBy(event.getTargetId())) {
            this.getEffects().clear();
            this.getEffects().add((Object)new AddCountersSourceEffect(CounterType.P1P1.createInstance(event.getAmount())));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever damage that would be dealt to you is prevented, put that many +1/+1 counters on {this}.";
    }
}

