/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.ParleyCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.mana.ManaEffect;
import mage.game.Game;
import mage.players.Player;

class SelvalaExplorerReturnedEffect
extends ManaEffect {
    SelvalaExplorerReturnedEffect() {
        this.staticText = "Each player reveals the top card of their library. For each nonland card revealed this way, add {G} and you gain 1 life";
    }

    private SelvalaExplorerReturnedEffect(SelvalaExplorerReturnedEffect effect) {
        super((ManaEffect)effect);
    }

    public SelvalaExplorerReturnedEffect copy() {
        return new SelvalaExplorerReturnedEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        int maxPotentialGreenMana = 0;
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game == null) {
            return netMana;
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || player.getLibrary().isEmptyDraw()) continue;
            ++maxPotentialGreenMana;
        }
        netMana.add(Mana.GreenMana((int)maxPotentialGreenMana));
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        if (game == null) {
            return new Mana();
        }
        Player player = this.getPlayer(game, source);
        if (player == null) {
            return new Mana();
        }
        int parleyCount = ParleyCount.getInstance().calculate(game, source, (Effect)this);
        player.gainLife(parleyCount, game, source);
        return Mana.GreenMana((int)parleyCount);
    }
}

