/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.ParleyCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.ElephantToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class SelvalasChargeEffect
extends OneShotEffect {
    SelvalasChargeEffect() {
        super(Outcome.Benefit);
        this.staticText = "<i>Parley</i> &mdash; Each player reveals the top card of their library. For each nonland card revealed this way, you create a 3/3 green Elephant creature token";
    }

    private SelvalasChargeEffect(SelvalasChargeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SelvalasChargeEffect copy() {
        return new SelvalasChargeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int parley = ParleyCount.getInstance().calculate(game, source, (Effect)this);
            if (parley > 0) {
                new CreateTokenEffect((Token)new ElephantToken(), parley).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

