/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class SenatorLottDodSpellsTargetingYouCostModificationEffect
extends CostModificationEffectImpl {
    SenatorLottDodSpellsTargetingYouCostModificationEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "Spells your opponents cast that target you cost {2} more to cast";
    }

    protected SenatorLottDodSpellsTargetingYouCostModificationEffect(SenatorLottDodSpellsTargetingYouCostModificationEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)2);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Set allTargets;
        if (!(abilityToModify instanceof SpellAbility)) {
            return false;
        }
        if (!game.getOpponents(source.getControllerId()).contains(abilityToModify.getControllerId())) {
            return false;
        }
        Spell spell = (Spell)game.getStack().getStackObject(abilityToModify.getId());
        if (spell != null) {
            allTargets = CardUtil.getAllSelectedTargets((Ability)abilityToModify, (Game)game);
        } else {
            allTargets = CardUtil.getAllPossibleTargets((Ability)abilityToModify, (Game)game);
            if (allTargets.stream().anyMatch(target -> !this.isTargetCompatible((UUID)target, source, game))) {
                return false;
            }
        }
        return allTargets.stream().anyMatch(target -> this.isTargetCompatible((UUID)target, source, game));
    }

    private boolean isTargetCompatible(UUID target, Ability source, Game game) {
        Player targetPlayer = game.getPlayer(target);
        return targetPlayer != null && targetPlayer.getId().equals(source.getControllerId());
    }

    public SenatorLottDodSpellsTargetingYouCostModificationEffect copy() {
        return new SenatorLottDodSpellsTargetingYouCostModificationEffect(this);
    }
}

