/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class SengirTheDarkBaronWatcher
extends Watcher {
    private final Map<UUID, Integer> playerMap = new HashMap<UUID, Integer>();

    SengirTheDarkBaronWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.BEGINNING_PHASE_PRE) {
            game.getPlayers().values().stream().forEach(player -> this.playerMap.put(player.getId(), player.getLife()));
        }
    }

    public void reset() {
        this.playerMap.clear();
        super.reset();
    }

    int getLife(UUID playerId) {
        return Math.max(0, this.playerMap.getOrDefault(playerId, 0));
    }
}

