/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBaseToughnessSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class SentinelEffect
extends OneShotEffect {
    SentinelEffect() {
        super(Outcome.Detriment);
        this.staticText = "Change {this}'s base toughness to 1 plus the power of target creature blocking or blocked by {this}. <i>(This effect lasts indefinitely.)</i>";
    }

    private SentinelEffect(SentinelEffect effect) {
        super((OneShotEffect)effect);
    }

    public SentinelEffect copy() {
        return new SentinelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetPermanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller != null && targetPermanent != null) {
            int newToughness = CardUtil.overflowInc((int)targetPermanent.getPower().getValue(), (int)1);
            game.addEffect((ContinuousEffect)new SetBaseToughnessSourceEffect(newToughness, Duration.Custom), source);
            return true;
        }
        return false;
    }
}

